/*------------------------------------------------------------------------------*
 * File Name: OneColHeaderHandler.h												*
 * Creation: 08-20-2004	CPY														*
 * Copyright (c) OriginLab Corp. 2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY Creation 8/5/04 WKBOOK_CONTEXT_MENU_STANDARD_HANDLING					*
 *------------------------------------------------------------------------------*/

#ifndef _ONE_COL_HEADER_HANDLER_H
#define _ONE_COL_HEADER_HANDLER_H


// base class for user event handler when a single col header is selected 
class OneColHeaderHandler : public OriginEventsBase
{
public:
	/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
	/*
	virtual bool DoContextMenu(int x, int y, HWND hWnd) 
	{
		out_str("calling base class OneColHeaderHandler, should never come here");
		return false;
	}
	*/
};
/*

class InsertRelatedColsMenu : public Menu
{
public:
	InsertRelatedColsMenu(Column& col)
	{
		if(m_wksCol.Init(col))
		{
			Worksheet wks = m_wksCol.GetWorksheet();
			// the following does not work
			load_wks_default_context_menu(this, wks, IDR_CM_WKS, ID_WKS_COLHED);
			Add("Insert Columns...", InsertCols);
		}
	}
	bool bIsValid() {return m_wksCol.IsValid();}
protected:
	void InsertCols(uint nCmd)
	{
		m_wksCol.InsertColsDlg();
	}
private:
	WksColumn	m_wksCol;
};
*/

#define IDM_CM_INSERT_COLS OC_MENURANGE_BEGIN

class OC_REGISTERED InsertRelatedCols : public OneColHeaderHandler
{
public:
	/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
	//	bool DoContextMenu(Column& col, int x, int y, HWND hWnd)
	/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK 
	//bool OnContextMenu(int x, int y)
	bool OnContextMenu(int x, int y, DWORD dwControl = 0)
	/// end EVENT_HANDLING_ETC_FOR_OK 
	/// end CORNER_OBJECT_FOR_NEW_WORKBOOK
	{
/*
		// test
		//Window wnd(hWnd);
		//printf("Window title = %s\n", wnd.Text);
		InsertRelatedColsMenu	myMenu(col);
		myMenu.TrackPopupMenu(0, x, y, hWnd);
*/
		/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
		//	if(!m_wksCol.Init(col))
		//		return false;
		/// end CORNER_OBJECT_FOR_NEW_WORKBOOK
		
		Worksheet wks = m_wksCol.GetWorksheet();
		Menu menu;
		load_default_context_menu(&menu, wks, IDR_CM_WKS, ID_WKS_COLHED);
		//menu.Add(NULL, 0, MF_SEPARATOR);
		//menu.Add("Add Columns...", IDM_CM_INSERT_COLS);
		// first remove unwanted menus
		menu.RemoveMenu(0, MF_BYPOSITION);//Plot
		menu.RemoveMenu(0, MF_BYPOSITION);//Separator
		menu.RemoveMenu(6, MF_BYPOSITION);//Clear
		menu.RemoveMenu(6, MF_BYPOSITION);//Separator
		menu.RemoveMenu(6, MF_BYPOSITION);// set col as
		menu.RemoveMenu(6, MF_BYPOSITION);// set col value
		menu.RemoveMenu(6, MF_BYPOSITION);// fill col with
		menu.RemoveMenu(6, MF_BYPOSITION);//Separator
		
		menu.RemoveMenu(10, MF_BYPOSITION);
		menu.RemoveMenu(10, MF_BYPOSITION);
		menu.RemoveMenu(10, MF_BYPOSITION);
		menu.RemoveMenu(10, MF_BYPOSITION);
		menu.RemoveMenu(10, MF_BYPOSITION);
		menu.RemoveMenu(10, MF_BYPOSITION);// mask
		menu.RemoveMenu(10, MF_BYPOSITION);// set categorical
		
		menu.InsertMenu(0, MF_BYPOSITION | MF_SEPARATOR);
		menu.InsertMenu(0, MF_BYPOSITION, IDM_CM_INSERT_COLS, _L("Add Columns..."));
		
		/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
		//	int		nCmd = menu.TrackPopupResMenu(0,  x, y, hWnd);
		int		nCmd = menu.TrackPopupResMenu(0,  x, y, GetWindow());
		/// end CORNER_OBJECT_FOR_NEW_WORKBOOK
		
		if(IDM_CM_INSERT_COLS == nCmd)
		{
			m_wksCol.InsertColsDlg();
		}
		else
			wks.ProcessCommand(nCmd);
		return true;
	}

	virtual	bool SetObj(OriginObject &obj)
	{
		Column col;
		col = (Column) obj;
		if( col )
		{
			return m_wksCol.Init(col);
		}
		
		return FALSE;
	}
	
	
	virtual bool OnObjectHotSpotClick(int nRow, int nCol)
	{
		m_wksCol.InsertColsDlg();
		return TRUE;
	}
private:
	WksColumn	m_wksCol;	
};


#endif //_ONE_COL_HEADER_HANDLER_H

